<%-- 
    Document   : ImoshochuShop
    Created on : 2010/01/26, 20:26:17
    Author     : tomoharu
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
   "http://www.w3.org/TR/html4/loose.dtd">

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>芋焼酎酒店買い物かご導入版</title>
    </head>
    <body bgcolor="#CCFFCC">
        <h1>芋焼酎酒店</h1>
        <p>店主お薦めの芋焼酎を集めてみました。</p>
        <form action="/JPASample02-war/BasketServlet" id="catalog">
            <h2>芋焼酎カタログ</h2>
            <table border="1">
                <tr>
                    <th>選択</th>
                    <th>銘柄</th>
                    <th>銘柄読み方</th>
                    <th>度数</th>
                    <th>麹</th>
                    <th>芋の種類</th>
                    <th>製造元</th>
                    <th>容量(ℓ)</th>
                    <th>単価</th>
                </tr>
            <c:forEach var="meigara" items="${sessionScope.imoCatalog}">
                <tr>
                    <td><input type="checkbox" name="items" value="${meigara.id}"></td>
                    <td>${meigara.name}</td>
                    <td>${meigara.nameKana}</td>
                    <td>${meigara.dosu}</td>
                    <td>${meigara.koji}</td>
                    <td>${meigara.sweetPotatoName}</td>
                    <td>${meigara.manufacturer}</td>
                    <td>${meigara.volume}</td>
                    <td>${meigara.price}</td>
                </tr>
            </c:forEach>
            </table>
            <input type="submit" value="買い物かごに追加する">
        </form>
        <form action="/JPASample02-war/RefreshBasketServlet" id="refresh_basket">

            <hr>
            <h2>買い物かご</h2>
            <table border="1">
                <tr>
                    <th>id</th>
                    <th>銘柄</th>
                    <th>単価</th>
                    <th>本数</th>
                    <th>金額</th>
                </tr>
            <c:forEach var="basket_item" items="${sessionScope.basket}">
                <tr>
                    <td><input type="hidden" name="id" value=${basket_item.id} size="5">${basket_item.id}</td>
                    <td>${basket_item.name}</td>
                    <td>${basket_item.price}</td>
                    <td><input type="text" name="quantity" value="${basket_item.quantity}" size="3"></td>
                    <td>${basket_item.itemTotal}</td>
                </tr>
            </c:forEach>
            </table>
            <table border="1">
                <tr>
                    <th>明細合計</th>
                    <th>送料</th>
                    <th>総合計</th>
                </tr>
                <tr>
            <c:forEach var="total" items="${sessionScope.totalCharge}">
                    <td>${total}</td>
            </c:forEach>
                </tr>
            </table>
            <input type="submit" value="買い物かごを再表示する">
        </form>
        <form action="/JPASample02-war/RemoveBasketServlet" id="remove_basket">
            <input type="submit" value="レジへ進む">
        </form>
    </body>
</html>
